define(['SupportSummaryController', 'SupportConstants'], function() {
	'use strict';

	describe("The Support Summary Controller", function (){
		var controller,
			scope,
			stateParams,
			windowMock = window,
			section = "people-like-you",
			sectionName = "People Like You",
			featureName = "Support";

		beforeEach(function() {
			module('angularTemplateApp');
			inject(function($controller, $rootScope, $stateParams, $state) {
				scope = $rootScope.$new();
				stateParams = $stateParams;

				stateParams.section = section;
				$state.current.data = {
					appletName: featureName,
					paramSections: [{paramValue: section, sectionName: sectionName}]
				};

				controller = $controller('SupportSummaryController', { $scope: scope });
			});
		});

		describe("when page is initialized", function() {
			it("should set the page header based on the section information", function() {
				expect(scope.sectionTitle).toBe(sectionName);
			});
			
			it("should set the feature name based on the section information", function() {
				expect(scope.featureName).toBe(featureName);
			});

			it("should set the template for the feature", function() {
				expect(scope.sectionTemplate).toBe('src/modules/support/pages/summary/partials/people-like-you_template.html');
			});
		});

		describe("when My VA Health link is clicked", function (){
		    beforeEach( function () {
		        spyOn(windowMock, 'open');
		        scope.openMvahLink();
		    });

		    it ("should open a new browser window", function() {
		        expect(windowMock.open).toHaveBeenCalledWith('../../../my-va-health/#/home', '_blank');
		    });
		});

		describe("when Mended Hearts link is clicked", function (){
		    beforeEach( function () {
		        spyOn(windowMock, 'open');
		        scope.openMendedHearts();
		    });

		    it ("should open a new browser window", function() {
		        expect(windowMock.open).toHaveBeenCalledWith('https://www.inspire.com/groups/mended-hearts-heart-disease/', '_blank');
		    });
		});
	});
});